////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
// -------------------------------------------------------------------------
//  File name:   SnapPreviewWnd.h
//  Version:     v1.00
//  Created:     7/IX/2007 by Kire.
//  Compilers:   Visual Studio.NET 2005
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#pragma once

#include "SnapTextPreview.h"
#include "SnapPreviewControls.h"



class CSnapPreviewWnd;



// The view within the snapshot preview window (CSnapPreviewWnd)
class CSnapPreviewView : public CView
{
public:	// Construction & destruction
	CSnapPreviewView();
	virtual ~CSnapPreviewView();
	int			m_nPrevFrame;

public:	// Operations
	bool Create( DWORD dwStyle,const RECT &rect,CWnd *pParentWnd,UINT nID );	// Creates the view window
	void SetCommonData(SV_COMMON_DATA *pCD) { m_pCD = pCD; }
	void InitDestRect();

protected:	// Virtual overrides
	virtual void OnDraw(CDC *pDC);
	virtual void PostNcDestroy();

protected:	// Message handlers
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	DECLARE_MESSAGE_MAP()

private:		// Member data
	CRect						m_rcClient, m_rcDest;

	SV_COMMON_DATA	*m_pCD;
};



// The view within the CSnapTextPreview docking frame
class CSnapTextView : public CView
{
public:	// Construction & destruction
	CSnapTextView();
	virtual ~CSnapTextView();

public:	// Operations
	bool Create( DWORD dwStyle,const RECT &rect,CWnd *pParentWnd,UINT nID );	// Creates the view window
	void SetCommonData(SV_COMMON_DATA *pCD) { m_pCD = pCD; }
	void ResetColumns();
	CDC *GetBkDC() { return &m_dcBack; }

protected:	// Virtual overrides
	virtual void OnDraw(CDC *pDC);
	virtual void PostNcDestroy();

protected:	// Message handlers
	afx_msg int OnCreate(LPCREATESTRUCT lpcs);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	DECLARE_MESSAGE_MAP()

private:		// Member data
	CRect						m_rcClient;
	CFont						m_fntInfo;
	CBitmap					m_bmBack;
	CDC							m_dcBack;
	int							m_nColumnWidth;
	CArray<int,int>	m_arrColHeights;

	SV_COMMON_DATA	*m_pCD;
};



// CSnapPreviewWnd frame
class CSnapPreviewWnd : public CXTPFrameWnd
{
	friend class CSnapPreviewView;

	DECLARE_DYNCREATE(CSnapPreviewWnd)

public:	// Construction & destruction
	CSnapPreviewWnd();
	virtual ~CSnapPreviewWnd();

public:	// Operations
	BOOL Create(DWORD dwStyle,const RECT& rect,CWnd* pParentWnd);
	CXTPDockingPaneManager* GetDockingPaneManager() { return &m_paneManager; }
private:
	bool ReadLogFiles();

protected:	// Message handlers
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();

	afx_msg LRESULT OnDockingPaneNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDialogNotify(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()

public:		// Static members
	static void RegisterViewClass();

private:	// Member data
	CSnapPreviewView				*m_pView;					// The view within (captured images)
	CSnapTextView						*m_pTextView;			// The view within the text preview pane
	CXTPDockingPaneManager	m_paneManager;		// The pane manager

	CSnapTextPreview				m_paneText;				// The text preview pane
	CSnapPreviewControls		m_paneControls;		// The controls pane

	CSnapPreviewDialog			*m_pControlsDlg;	// The dialog within the controls pane

private:	// Other data
	SV_COMMON_DATA *m_pCD;
};
